/*

HS-SIC-NAICS-SITC Concordance Project

This program creates files associated with Pierce and Schott's HS-SIC/NAICS concordance. 

copyright Peter K. Schott / Justin R. Pierce

This program, associated files and a working paper describing our overall HS-SIC-NAICS concordance effort 
can be found at http://www.som.yale.edu/faculty/pks4/


*/


clear
capture log close
set more off
set mem 1000m
log using full_conc_92.log, replace

use appndxd, clear
keep sicbase92 pc5
rename pc5 sic5
drop if sic5=="N/A"
sort sicbase92
save t1, replace

use hs_sic_m_allsources_1989_2006, clear
keep hs sicbase92
drop if sicbase92==""
sort sicbase92
joinby sicbase92 using t1, unmatched(both)
tab _merge
keep if _merge==3
drop _merge
rename sicbase92 basecode
sort hs
save m_basecode_92, replace
outsheet using m_basecode_92.csv, replace

use hs_sic_x_allsources_1989_2006, clear
keep hs sicbase92
drop if sicbase92==""
sort sicbase92
joinby sicbase92 using t1, unmatched(both)
tab _merge
keep if _merge==3
drop _merge
rename sicbase92 basecode
sort hs
save x_basecode_92, replace
outsheet using x_basecode_92.csv, replace

capture log close
