
clear
set more off
set mem 1000m
cd "C:\Users\Justin\Documents\RA Work\Jensen_Schott_Bernard\hs_sic_naics_concordance"
capture log close
log using baseroot_conc_create.log, replace

foreach x in imports exports {
	use hs_sic_naics_`x'_89_106_20091016, clear
	keep commodity sic sic_matchtype
	order commodity sic
	keep commodity sic
	rename commodity hs
	rename sic sicbaseroot
	sort sicbaseroot
	save hs_sic_`x', replace
}

foreach x in imports exports {
	use hs_sic_naics_`x'_89_106_20091016, clear
	keep commodity naics naics_matchtype
	order commodity naics
	keep commodity naics
	rename commodity hs
	rename naics naicsbaseroot
	sort naicsbaseroot
	save hs_naics_`x', replace
}

foreach x in imports exports {
	use pd92, clear
	keep sicbase92 pc5
	drop if pc5=="N/A"
	gen sicbaseroot=substr(sicbase92,1,4)
	rename pc5 sic5
	keep sicbaseroot sic5
	sort sicbaseroot
	joinby sicbaseroot using hs_sic_`x', unmatched(both)
	tab _merge
	keep if _merge==3
	drop _merge
	order hs sic5
	save hs_sic5_`x'_92, replace
	outsheet using hs_sic5_`x'_92.csv, replace
}

foreach y in 97 02 {
	foreach x in imports exports {
		noisily display "`x'`y'"
		use pd`y', clear
		keep baseroot pc7
		drop if baseroot=="N/A"
		drop if pc7=="N/A"
		rename pc7 naics7
		rename baseroot naicsbaseroot
		sort naicsbaseroot
		joinby naicsbaseroot using hs_naics_`x', unmatched(both)
		tab _merge
		keep if _merge==3
		drop _merge
		order hs naics7
		save hs_naics7_`x'_`y', replace
		outsheet using hs_naics7_`x'_`y'.csv, replace
	}
}

capture log close
