*File given is for Schedule B (Export) HS Codes
*Simply change relevant filenames for HTS (Import) HS codes

set more off
quietly {
   forvalues y=89/109 {

	local ylong = `y'+1900
	local ylead = `ylong'+1
 
	noisily display " "
	noisily display " "
	noisily display "NEW LOOP " [`y']
	noisily display " "
	noisily display " "
	
	*get obsolete-new files ready
	use sch_b_concordances_20100522_1989_2009, clear

	keep if effyr>=`ylong'
	keep obsolete setyr
	drop if obsolete==.
	capture duplicates drop 
	sort obsolete
	save temp_obsolete, replace

	use sch_b_concordances_20100522_1989_2009, clear
	keep if effyr<=`ylong'
	keep new setyr
	drop if new==.
	duplicates drop 
	sort new
	save temp_new, replace
	
	*read in trade data and collapse to appropriate level
	use exp_detl_`y'_12_v9, clear
	gen v000000=all_val_yr/1000000
	gen t=1
	noisily table t, c(sum v000000) f(%15.0f)
	drop t v000000
	rename all_val_yr v
	destring commodity, force g(hs1)
	collapse (sum) v, by(hs1)
	format hs1 %15.0f

	*merge in obsolete-code family identifiers
	rename hs1 obsolete
	sort obsolete
	merge obsolete using temp_obsolete, keep(setyr)
	noisily tab _merge
	drop if _merge==2
	drop _merge
	rename obsolete hs1

	*merge in new-code family identifiers
	rename hs1 new
	sort new
	merge new using temp_new, keep(setyr) update
	noisily tab _merge
	drop if _merge==2
	drop _merge
	rename new hs1

	sort setyr
	rename hs1 hs`ylong'
	save stata_x_10_`ylong'_01_precollapse, replace

	*reset hs codes to family identifiers where appropriate
	replace hs=setyr if setyr~=.
	gen i = hs<100000
	gen v000000=v/1000000
	noisily display "Record replacements of acutal by synthetic"
	noisily tab i
	noisily table i, c(sum v000000) f(%15.0f)
	*collapse (sum) v, by(hs country1 alpha1 rp month year)
	collapse (sum) v, by(hs)
	gen i = hs<100000
	noisily display "Record breakdown of concorded into actual and synthetic"
	noisily tab i
	save stata_x_10_`ylong'_01, replace
  }
}

forvalues y=1989/2009 {
	use stata_x_10_`y'_01_precollapse, clear
	drop v
	drop if setyr==.
	sort setyr hs`y'
	save junk_x_`y', replace
}
use junk_x_1989, clear
forvalues y=1990/2009 {
	display [`y']
	merge setyr using junk_x_`y' 
	tab _merge
	drop _merge
	order setyr
	sort setyr hs`y'
}
forvalues y=1989/2009 {
	egen i`y' = tag(setyr hs`y')
	replace hs`y'=. if i`y'==0
	drop i`y'
}
*now sort each column within setyr
gen x=1
gen xx=sum(x)
drop x
reshape long hs, i(xx setyr) j(year)
sort year setyr hs
drop xx
egen xx = seq(), by(year)
reshape wide hs, i(xx setyr) j(year)
drop xx
save setyr_x_1989_2009, replace
outsheet using setyr_x_1989_2009.csv, replace

*create simple concordance file
forvalues x=1989/2009 {
	clear
	use stata_x_10_`x'_01_precollapse
	rename hs`x' hs
	keep hs setyr
	drop if setyr==.
	display `x'
	duplicates report hs
	save t`x'_precollapse, replace
}

use t1989_precollapse
forvalues x=1990/2009 {
	append using t`x'_precollapse
}
duplicates drop hs setyr, force
duplicates report hs
save simple_schedule_b_1989_2009, replace
outsheet using simple_schedule_b_1989_2009.csv, replace
